% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalAccess.R
\name{getGlobal}
\alias{getGlobal}
\alias{setGlobal}
\alias{setData}
\alias{setDataTable}
\alias{getAutoNavigation}
\alias{setAutoNavigation}
\alias{getCores}
\alias{setCores}
\alias{getSignificant}
\alias{setSignificant}
\alias{getPrecision}
\alias{setPrecision}
\alias{getASevents}
\alias{getAnnotationHub}
\alias{setAnnotationHub}
\alias{getASevent}
\alias{setASevent}
\alias{getEvent}
\alias{setEvent}
\alias{getGenes}
\alias{getCategories}
\alias{getCategory}
\alias{setCategory}
\alias{getCategoryData}
\alias{getActiveDataset}
\alias{setActiveDataset}
\alias{getClinicalData}
\alias{getSubjectId}
\alias{getSubjectAttributes}
\alias{getSampleInfo}
\alias{setSampleInfo}
\alias{getSampleId}
\alias{getSampleAttributes}
\alias{getJunctionQuantification}
\alias{getGeneExpression}
\alias{setNormalisedGeneExpression}
\alias{getInclusionLevels}
\alias{setInclusionLevels}
\alias{getInclusionLevelsSummaryStatsCache}
\alias{setInclusionLevelsSummaryStatsCache}
\alias{getPCA}
\alias{setPCA}
\alias{getICA}
\alias{setICA}
\alias{getCorrelation}
\alias{setCorrelation}
\alias{getGroupIndependenceTesting}
\alias{setGroupIndependenceTesting}
\alias{getSpecies}
\alias{setSpecies}
\alias{getAssemblyVersion}
\alias{setAssemblyVersion}
\alias{getAnnotationName}
\alias{setAnnotationName}
\alias{getURLtoDownload}
\alias{setURLtoDownload}
\title{Get or set globally accessible elements}
\usage{
getGlobal(category = getCategory(), ..., sep = "_")

setGlobal(category = getCategory(), ..., value, sep = "_")

setData(data)

setDataTable(name, value, category = getCategory())

getAutoNavigation()

setAutoNavigation(auto)

getCores()

setCores(integer)

getSignificant()

setSignificant(integer)

getPrecision()

setPrecision(integer)

getASevents()

getAnnotationHub()

setAnnotationHub(ah)

getASevent()

setASevent(event, data = NULL)

getEvent()

setEvent(event, data = NULL)

getGenes()

getCategories()

getCategory()

setCategory(category)

getCategoryData()

getActiveDataset()

setActiveDataset(dataset)

getClinicalData(attrs = NULL)

getSubjectId()

getSubjectAttributes()

getSampleInfo()

setSampleInfo(value, category = getCategory())

getSampleId()

getSampleAttributes()

getJunctionQuantification(category = getCategory())

getGeneExpression(item = NULL, category = getCategory(), EList = FALSE)

setNormalisedGeneExpression(geneExpr, category = getCategory())

getInclusionLevels()

setInclusionLevels(incLevels, category = getCategory())

getInclusionLevelsSummaryStatsCache(category = getCategory())

setInclusionLevelsSummaryStatsCache(cache, category = getCategory())

getPCA(category = getCategory())

setPCA(pca, category = getCategory())

getICA(category = getCategory())

setICA(ica, category = getCategory())

getCorrelation(category = getCategory())

setCorrelation(correlation, category = getCategory())

getGroupIndependenceTesting(category = getCategory())

setGroupIndependenceTesting(groupIndependenceTesting, category = getCategory())

getSpecies(category = getCategory())

setSpecies(species, category = getCategory())

getAssemblyVersion(category = getCategory())

setAssemblyVersion(assembly, category = getCategory())

getAnnotationName(category = getCategory())

setAnnotationName(annotName, category = getCategory())

getURLtoDownload()

setURLtoDownload(url)
}
\arguments{
\item{category}{Character: data category}

\item{...}{Arguments to identify a variable}

\item{sep}{Character to separate identifiers}

\item{value}{Value to attribute to an element}

\item{data}{Matrix or data frame: alternative splicing information}

\item{name}{Character: data table name}

\item{auto}{Boolean: enable automatic navigation of browser history?}

\item{integer}{Integer: value of the setting}

\item{ah}{AnnotationHub}

\item{event}{Character: alternative splicing event}

\item{dataset}{Character: dataset name}

\item{attrs}{Character: name of attributes to retrieve (if \code{NULL}, the
whole dataset is returned)}

\item{item}{Character: name of specific item to retrieve (if \code{NULL}, the
whole list is returned)}

\item{EList}{Boolean: return gene expression datasets as \code{EList} if
possible or as data frames?}

\item{geneExpr}{Data frame or matrix: normalised gene expression}

\item{incLevels}{Data frame or matrix: inclusion levels}

\item{cache}{List of summary statistics}

\item{pca}{\code{prcomp} object (principal component analysis)}

\item{ica}{Object containing independent component analysis}

\item{correlation}{\code{prcomp} object (correlation analyses)}

\item{groupIndependenceTesting}{Object containing group independence testing
results}

\item{species}{Character: species}

\item{assembly}{Character: assembly version}

\item{annotName}{Character: annotation name}

\item{url}{Character: URL links to download}
}
\value{
Getters return globally accessible data, whereas setters return
\code{NULL} as they are only used to modify the Shiny session's state
}
\description{
Get or set globally accessible elements
}
\note{
Needs to be called inside a reactive function
}
\seealso{
Other functions to get and set global variables: 
\code{\link{getClinicalMatchFrom}()},
\code{\link{getDifferentialExpression}()},
\code{\link{getDifferentialSplicing}()},
\code{\link{getGroups}()},
\code{\link{getHighlightedPoints}()},
\code{\link{getSelectedDataPanel}()}
}
\concept{functions to get and set global variables}
\keyword{internal}
