% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_miso.R
\name{getDataRows}
\alias{getDataRows}
\title{Get rows of a data frame between two row indexes}
\usage{
getDataRows(i, data, firstRow, lastRow)
}
\arguments{
\item{i}{Integer: current iteration}

\item{data}{Data.frame: contains the data of interest}

\item{firstRow}{Vector of integers: First row index of interest; value must
be less than the respective last row index and less than the number of rows
in the data frame}

\item{lastRow}{Vector of integers: Last row index of interest; value must be 
higher than the respective first row index and less than the number of rows
in the data frame}
}
\value{
Data frame subset from two row indexes (returns NA if the first row 
index is NA)
}
\description{
Get rows of a data frame between two row indexes
}
\details{
For a given iteration i, returns data from \code{firstRow[i]} to
\code{lastRow[i]}
}
\keyword{internal}
