% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{customRowMeans}
\alias{customRowMeans}
\alias{customRowMedians}
\alias{customRowVars}
\alias{customRowMins}
\alias{customRowMaxs}
\alias{customRowRanges}
\alias{customColMedians}
\title{Calculate statistics for each row or column of a matrix}
\usage{
customRowMeans(mat, na.rm = FALSE, fast = FALSE)

customRowMedians(mat, na.rm = FALSE, fast = FALSE)

customRowVars(mat, na.rm = FALSE, fast = FALSE)

customRowMins(mat, na.rm = FALSE, fast = FALSE)

customRowMaxs(mat, na.rm = FALSE, fast = FALSE)

customRowRanges(mat, na.rm = FALSE, fast = FALSE)

customColMedians(mat, na.rm = FALSE, fast = FALSE)
}
\arguments{
\item{mat}{Matrix}

\item{na.rm}{Boolean: remove missing values (\code{NA})?}

\item{fast}{Boolean: use \code{Rfast} functions? They may return different
results from R built-in functions}
}
\value{
Vector of selected statistic
}
\description{
Calculate statistics for each row or column of a matrix
}
\examples{
df <- rbind("Gene 1"=c(3, 5, 7), "Gene 2"=c(8, 2, 4), "Gene 3"=c(9:11))
psichomics:::customRowMeans(df)
psichomics:::customRowVars(df, fast=TRUE)
}
\keyword{internal}
