% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_correlation.R
\name{correlateGEandAS}
\alias{correlateGEandAS}
\title{Correlate gene expression data against alternative splicing quantification}
\usage{
correlateGEandAS(geneExpr, psi, gene, ASevents = NULL, ...)
}
\arguments{
\item{geneExpr}{Matrix or data frame: gene expression data}

\item{psi}{Matrix or data frame: alternative splicing quantification data}

\item{gene}{Character: gene symbol for genes of interest}

\item{ASevents}{Character: alternative splicing events to correlate with
gene expression of a gene (if \code{NULL}, the events will be automatically
retrieved from the given gene)}

\item{...}{Extra parameters passed to \link[stats]{cor.test}}
}
\value{
List of correlations where each element contains:
\item{\code{eventID}}{Alternative splicing event identifier}
\item{\code{cor}}{Correlation between gene expression and alternative
splicing quantification of one alternative splicing event}
\item{\code{geneExpr}}{Gene expression for the selected gene}
\item{\code{psi}}{Alternative splicing quantification for the alternative
splicing event}
}
\description{
Test for association between paired samples' gene expression (for any genes
of interest) and alternative splicing quantification.
}
\examples{
annot <- readFile("ex_splicing_annotation.RDS")
junctionQuant <- readFile("ex_junctionQuant.RDS")
psi <- quantifySplicing(annot, junctionQuant, eventType=c("SE", "MXE"))

geneExpr <- readFile("ex_gene_expression.RDS")
correlateGEandAS(geneExpr, psi, "ALDOA")
}
\seealso{
Other functions to correlate gene expression and alternative splicing: 
\code{\link{[.GEandAScorrelation}()}
}
\concept{functions to correlate gene expression and alternative splicing}
