% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_geNormalisationFiltering.R
\name{convertGeneIdentifiers}
\alias{convertGeneIdentifiers}
\title{Convert gene identifiers}
\usage{
convertGeneIdentifiers(
  annotation,
  genes,
  key = "ENSEMBL",
  target = "SYMBOL",
  ignoreDuplicatedTargets = TRUE
)
}
\arguments{
\item{annotation}{\code{OrgDb} with genome wide annotation for an organism or
\code{character} with species name to query \code{OrgDb}, e.g.
\code{"Homo sapiens"}}

\item{genes}{Character: genes to be converted}

\item{key}{Character: type of identifier used, e.g. \code{ENSEMBL}; read
\code{?AnnotationDbi::columns}}

\item{target}{Character: type of identifier to convert to; read
\code{?AnnotationDbi::columns}}

\item{ignoreDuplicatedTargets}{Boolean: if \code{TRUE}, identifiers that
share targets with other identifiers will not be converted}
}
\value{
Character vector of the respective targets of gene identifiers. The
previous identifiers remain other identifiers have the same target (in case
\code{ignoreDuplicatedTargets = TRUE}) or if no target was found.
}
\description{
Convert gene identifiers
}
\examples{
# Use species name to automatically look for a OrgDb database
sp <- "Homo sapiens"
genes <- c("ENSG00000012048", "ENSG00000083093", "ENSG00000141510",
           "ENSG00000051180")
convertGeneIdentifiers(sp, genes)
convertGeneIdentifiers(sp, genes, key="ENSEMBL", target="UNIPROT")

# Alternatively, set the annotation database directly
ah <- AnnotationHub::AnnotationHub()
sp <- AnnotationHub::query(ah, c("OrgDb", "Homo sapiens"))[[1]]
columns(sp) # these attributes can be used to change the attributes

convertGeneIdentifiers(sp, genes)
convertGeneIdentifiers(sp, genes, key="ENSEMBL", target="UNIPROT")
}
\seealso{
Other functions for gene expression pre-processing: 
\code{\link{filterGeneExpr}()},
\code{\link{normaliseGeneExpression}()},
\code{\link{plotGeneExprPerSample}()},
\code{\link{plotLibrarySize}()},
\code{\link{plotRowStats}()}
}
\concept{functions for gene expression pre-processing}
