% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_suppa.R
\name{parseSuppaGeneric}
\alias{parseSuppaGeneric}
\alias{parseSuppaSE}
\alias{parseSuppaRI}
\alias{parseSuppaALE}
\alias{parseSuppaAFE}
\alias{parseSuppaMXE}
\alias{parseSuppaA3SS}
\alias{parseSuppaA5SS}
\title{Parse junctions of an event from SUPPA}
\usage{
parseSuppaGeneric(junctions, strand, coords, plus_pos, minus_pos)

parseSuppaSE(junctions, strand)

parseSuppaRI(junctions, strand)

parseSuppaALE(junctions, strand)

parseSuppaAFE(junctions, strand)

parseSuppaMXE(junctions, strand)

parseSuppaA3SS(junctions, strand)

parseSuppaA5SS(junctions, strand)
}
\arguments{
\item{junctions}{List of integers: exon-exon junctions of an event}

\item{strand}{Character: positive-sense (\code{+}) or negative-sense
(\code{-}) strand}

\item{coords}{Character: coordinate positions to fill}

\item{plus_pos}{Integer: index of the coordinates for a plus strand event}

\item{minus_pos}{Integer: index of the coordinates for a minus strand event}
}
\value{
Data frame of parsed junctions
}
\description{
Parse junctions of an event from SUPPA
}
\details{
The following event types are available to be parsed:
\itemize{
 \item{\bold{SE} (exon skipping)}
 \item{\bold{RI} (retained intron)}
 \item{\bold{MXE} (mutually exclusive exons)}
 \item{\bold{A5SS} (alternative 5' splice site)}
 \item{\bold{A3SS} (alternative 3' splice site)}
 \item{\bold{ALE} (alternative last exon)}
 \item{\bold{AFE} (alternative first exon)}
}
}
\examples{
# Parse generic event (in this case, an exon skipping event)
junctions <- read.table(text = "169768099 169770024 169770112 169771762")
coords <- c("C1.end", "A1.start", "A1.end", "C2.start")
plus  <- 1:4
minus <- 1:4
psichomics:::parseSuppaGeneric(junctions, strand = "+", coords, plus, minus)

junctions <- read.table(text = "169768099 169770024 169770112 169771762")
psichomics:::parseSuppaSE(junctions, "+")

junctions <- read.table(text = "196709749 196709922 196711005 196711181")
psichomics:::parseSuppaRI(junctions, "+")

junctions <- read.table(
    text = "24790610 24792494 24792800 24790610 24795476 24795797")
psichomics:::parseSuppaALE(junctions, "+")

junctions <- read.table(
    text = "169763871 169764046 169767998 169764550 169765124 169767998")
psichomics:::parseSuppaAFE(junctions, "+")

junctions <- read.table(
    text = "202060671 202068453 202068489 202073793 202060671 202072798 202072906 202073793")
psichomics:::parseSuppaMXE(junctions, "+")

junctions <- read.table(text = "169772450 169773216 169772450 169773253")
psichomics:::parseSuppaA3SS(junctions, "+")

junctions <- read.table(text = "50193276 50197008 50192997 50197008")
psichomics:::parseSuppaA5SS(junctions, "+")
}
\seealso{
\code{\link{parseSuppaEvent}()}
}
\keyword{internal}
