% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_mats.R
\name{parseMatsGeneric}
\alias{parseMatsGeneric}
\alias{parseMatsSE}
\alias{parseMatsMXE}
\alias{parseMatsRI}
\alias{parseMatsA3SS}
\alias{parseMatsA5SS}
\alias{parseMatsAFE}
\alias{parseMatsALE}
\title{Parse junctions of an alternative splicing event from MATS according to event 
type}
\usage{
parseMatsGeneric(junctions, strand, coords, plus_pos, minus_pos)

parseMatsSE(junctions, strand)

parseMatsMXE(junctions, strand)

parseMatsRI(junctions, strand)

parseMatsA3SS(junctions, strand)

parseMatsA5SS(junctions, strand)

parseMatsAFE(junctions, strand)

parseMatsALE(junctions, strand)
}
\arguments{
\item{junctions}{Integer: event's junctions}

\item{strand}{Character: strand of the event}

\item{coords}{Character: names of the alternative splicing coordinates}

\item{plus_pos}{Integer: match of each junction in the respective coordinate
for the plus strand}

\item{minus_pos}{Integer: match of each junction in the respective coordinate
for the minus strand}
}
\value{
Data frame with parsed junctions
}
\description{
Parse junctions of an alternative splicing event from MATS according to event 
type
}
\details{
The following event types are ready to be parsed:
\itemize{
 \item{\bold{SE} (skipped exon)}
 \item{\bold{MXE} (mutually exclusive exon)}
 \item{\bold{RI} (retained intron)}
 \item{\bold{A5SS} (alternative 5' splice site)}
 \item{\bold{A3SS} (alternative 3' splice site)}
 \item{\bold{AFE} (alternative first exon)}
 \item{\bold{ALE} (alternative last exon)}
}

You can use \code{parseMatsGeneric} to parse other event types.
}
\examples{
# Parse generic event (in this case, an exon skipping event)
junctions <- read.table(text=
    "79685787 79685910 79685796 79685910 79679566 79679751")
coords <- c("A1.start", "A1.end",
            "C1.start", "C1.end",
            "C2.start", "C2.end")
plus  <- c(1:6)
minus <- c(2:1, 6:3)
psichomics:::parseMatsGeneric(junctions, strand = "+", coords, plus, minus)

# Parse exon skipping event
junctions <- read.table(text=
    "79685787 79685910 79685796 79685910 79679566 79679751")
psichomics:::parseMatsSE(junctions, strand = "+")

# Parse mutually exclusive exon event
junctions <- read.table(text=
"158282161 158282276 158282689 158282804 158281047 158281295 158283950 158284199")
psichomics:::parseMatsMXE(junctions, strand = "+")

# Parse retained intron event
junctions <- read.table(text=
    "15929853 15932100 15929853 15930016 15930687 15932100")
psichomics:::parseMatsRI(junctions, strand = "+")

# Parse alternative 3' splicing site event
junctions <- read.table(text=
    "79685787 79685910 79685796 79685910 79679566 79679751")
psichomics:::parseMatsA3SS(junctions, strand = "+")

# Parse alternative 5' splicing site event
junctions <- read.table(text=
    "102884421 102884501 102884421 102884489 102884812 102885881")
psichomics:::parseMatsA5SS(junctions, strand = "+")

# Parse alternative first exon event
junctions <- read.table(text=
    "16308723 16308879 16308967 16309119 16314269 16314426")
psichomics:::parseMatsAFE(junctions, strand = "+")

# Parse alternative last exon event
junctions <- read.table(text=
    "111858645 111858828 111851063 111851921 111850441 111850543")
psichomics:::parseMatsAFE(junctions, strand = "+")
}
\seealso{
\code{\link{parseMatsEvent}()}
}
\keyword{internal}
