% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_inclusionLevelsFilter.R
\name{filterPSI}
\alias{filterPSI}
\title{Filter alternative splicing quantification}
\usage{
filterPSI(
  psi,
  eventType = NULL,
  eventSubtype = NULL,
  minPSI = -Inf,
  maxPSI = Inf,
  minMedian = -Inf,
  maxMedian = Inf,
  minLogVar = -Inf,
  maxLogVar = Inf,
  minRange = -Inf,
  maxRange = Inf
)
}
\arguments{
\item{psi}{Data frame or matrix: alternative splicing quantification}

\item{eventType}{Character: filter data based on event type; check all event
types available by using \code{getSplicingEventTypes(psi)}, where \code{psi}
is the alternative splicing quantification data; if \code{eventType = NULL},
events are not filtered by event type}

\item{eventSubtype}{Character: filter data based on event subtype; check all
event subtypes available in your data by using
\code{unique(getSplicingEventData(psi)$subtype)}, where \code{psi} is the
alternative splicing quantification data; if \code{eventSubtype = NULL},
events are not filtered by event subtype}

\item{minPSI}{Numeric: minimum PSI value}

\item{maxPSI}{Numeric: maximum PSI value}

\item{minMedian}{Numeric: minimum median PSI per splicing event}

\item{maxMedian}{Numeric: maximum median PSI per splicing event}

\item{minLogVar}{Numeric: minimum log10(PSI variance) per splicing event}

\item{maxLogVar}{Numeric: maximum log10(PSI variance) per splicing event}

\item{minRange}{Numeric: minimum PSI range across samples per splicing event}

\item{maxRange}{Numeric: maximum PSI range across samples per splicing event}
}
\value{
Boolean vector indicating which splicing events pass the thresholds
}
\description{
Filter alternative splicing quantification
}
\examples{
# Calculate PSI for skipped exon (SE) and mutually exclusive (MXE) events
annot <- readFile("ex_splicing_annotation.RDS")
junctionQuant <- readFile("ex_junctionQuant.RDS")

psi <- quantifySplicing(annot, junctionQuant, eventType=c("SE", "MXE"))
# Filter PSI
psi[filterPSI(psi, minMedian=0.05, maxMedian=0.95, minRange=0.15), ]
}
\seealso{
Other functions for PSI quantification: 
\code{\link{getSplicingEventTypes}()},
\code{\link{listSplicingAnnotations}()},
\code{\link{loadAnnotation}()},
\code{\link{plotRowStats}()},
\code{\link{quantifySplicing}()}
}
\concept{functions for PSI quantification}
