% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_functions.R
\name{array_vars}
\alias{array_vars}
\title{List the array structure variables}
\usage{
array_vars(
  channel = "635",
  totsamples,
  FG = "",
  BG = "",
  FBG = "",
  blockspersample,
  chip_path = "data/array_data",
  sampleID_path = "data/array_sampleID/",
  mig_prefix = "_first",
  machine = "",
  date_process = ""
)
}
\arguments{
\item{channel}{A character indicating the channel that the data was scanned 
at. It is mostly included in the MFI variable names.}

\item{totsamples}{A numeric value indicating teh number of samples on a slide.}

\item{FG}{Optional:A character indicating the name of the foreground
variable name. if not specified its created as 
\code{paste0("F",channel,".Median")}}

\item{BG}{Optional:A character indicating the name of the background 
variable name.  if not specified its created as 
\code{paste0("B",channel,".Median")}}

\item{FBG}{Optional:A character indicating the name of the 
foreground - background variable name.  if not specified its 
created as \code{paste0("F",channel,".Median...B",channel)}}

\item{blockspersample}{A numeric value indicating the numer of blocks in a 
mini-array. The \code{".gal"} file can help in getting this}

\item{chip_path}{A character indicating the path of the folder  location with
the array data.}

\item{sampleID_path}{A character indicating the path of the folder location 
with the sample identifiers matching the array structure.}

\item{mig_prefix}{Optional: A character indicating the identifier of an MIG
dilution file}

\item{machine}{Optional:A character indicating the machine used to process
the data in the folder}

\item{date_process}{Optional:A character indicating the date
when the samples were processed.}
}
\value{
a list of parameters required to process the data

genepix_vars
}
\description{
A generic function returning a list with the data structure.
}
\examples{
## specify the the parameters to process the data
genepix_vars <- array_vars(
## the channel the data was processed in
  channel = "635",
  ## folder where the array data is stored
  chip_path = "data/array_data",
  ## the number of samples per slide or in as single run
  totsamples = 21,
  ## How many blocks each sample occupies
  blockspersample = 2,
  ## folder where the array data samples id files are stored
  sampleID_path = "data/array_sampleID/",
  ## optional
  mig_prefix = "_first",
  machine = 1,
  date_process = "0520"
)
genepix_vars
}
