% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/intersectoR.R
\docType{methods}
\name{intersectoR}
\alias{intersectoR}
\alias{intersectoR,kmeans,kmeans-method}
\alias{intersectoR,hclust,hclust-method}
\title{Generic intersectoR function}
\usage{
intersectoR(pSet1, pSet2, pval, ...)

\S4method{intersectoR}{kmeans,kmeans}(pSet1 = NA, pSet2 = NA, pval = 0.05, full = FALSE)

\S4method{intersectoR}{hclust,hclust}(pSet1 = NA, pSet2 = NA, pval = 0.05, full = FALSE, k = NULL)
}
\arguments{
\item{pSet1}{an object for a set of patterns where each entry is a set of genes associated with a single pattern}

\item{pSet2}{an object for a second set of patterns where each entry is a set of genes associated with a single pattern}

\item{pval}{the maximum p-value considered significant}

\item{...}{additional parameters depending on input object}

\item{full}{logical indicating whether to return full data frame of signigicantly overlapping sets. Default is false will return summary matrix.}

\item{k}{Numeric giving cut height for hclust objects, if a vector is given arguments will be applied to pSet1 and pSet2 in that order}
}
\value{
A list containing: Overlap matrix, overlap index, and overlapping sets.
}
\description{
A function to find and test the intersecting values of two sets of objects,
presumably the genes associated with patterns in two different datasets. Both the input objects
need to be of the same type either kmeans or hclust.
}
\examples{
ESepiGen4c1lmRNASeq <- p.ESepiGen4c1l$mRNA.Seq
rownames(ESepiGen4c1lmRNASeq) <- map.ESepiGen4c1l$GeneSymbols

k.RNAseq6l3c3t<-kmeans(p.RNAseq6l3c3t,22)
k.ESepiGen4c1l<-kmeans(ESepiGen4c1lmRNASeq,10)
intersectoR(k.RNAseq6l3c3t, k.ESepiGen4c1l, pval=.05)

h.RNAseq6l3c3t<-hclust(as.dist(1-(cor(t(p.RNAseq6l3c3t)))))
h.ESepiGen4c1l<-hclust(as.dist(1-(cor(t(ESepiGen4c1lmRNASeq)))))
intersectoR(pSet1=h.ESepiGen4c1l, pSet2=h.RNAseq6l3c3t, pval=.05, k=c(3,4))

}
