#' The position count matrix for INR.
#'
#' The position count matrix for the initiator (INR) core promoter element. This
#' matrix was obtained from the JASPAR public domain database, but was
#' originally published by P. Bucher (1990); in that publication (and elsewhere)
#' it was termed Cap signal.
#'
#' @format A matrix with named rows corresponding to the counts for each of
#'   the four nucleotides.
#'
#' @return The position count matrix for INR.
#'
#' @source http://jaspar.genereg.net
#' @references Bucher, P. (1990). Weight matrix descriptions of four eukaryotic
#'   RNA polymerase II promoter elements derived from 502 unrelated promoter
#'   sequences. Journal of Molecular Biology 212, 563???-578.
#' @references Mathelier, A., Zhao, X., Zhang, A.W., Parcy, F., Worsley-Hunt,
#'   R., Arenillas, D.J., Buchman, S., Chen, C.-Y., Chou, A., Ienasescu, H., et
#'   al. (2014). JASPAR 2014: an extensively expanded and updated open-access
#'   database of transcription factor binding profiles. Nucleic Acids Research
#'   42, D142--D147.
"INR"
