% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance.R
\name{dist_approx_impl}
\alias{dist_approx_impl}
\alias{dist_approx,proDAFit-method}
\alias{dist_approx,SummarizedExperiment-method}
\alias{dist_approx,ANY-method}
\title{Distance method for 'proDAFit' object}
\usage{
\S4method{dist_approx}{proDAFit}(object, by_sample = TRUE, blind = TRUE)

\S4method{dist_approx}{SummarizedExperiment}(object, by_sample = TRUE, blind = TRUE, ...)

\S4method{dist_approx}{ANY}(object, by_sample = TRUE, blind = TRUE, ...)
}
\arguments{
\item{object}{the 'proDAFit' object for which we calculate the distance or a matrix like
object for which 'proDAFit' is created internally}

\item{by_sample}{a boolean that indicates if the distances is calculated
between the samples (`by_sample = TRUE`) or between the proteins
(`by_sample = FALSE`). Default: `TRUE`}

\item{blind}{fit an intercept model for the missing values to make
sure that the results are not biased for the expected result.
Default: `TRUE`}

\item{...}{additional arguments to \code{proDA()} in case object is a
\code{SummarizedExperiment} or a \code{matrix}}
}
\value{
a list with two elements: `mean` and `sd` both are formally
  of class "dist"
}
\description{
The method calculates either the euclidean distance between samples or proteins
taking into account the missing values and the associated uncertainty.
Because with missing value no single deterministic distance can be
calculated two objects are returned: the mean and the associated
standard deviation of the distance estimates.
}
\examples{
  syn_data <- generate_synthetic_data(n_proteins = 10)
  fit <- proDA(syn_data$Y, design = syn_data$groups)
  dist_approx(fit)

}
