/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.biojava.utils.contract.Contract;

public class TypedProperties
extends Properties {
    public static final String DEFAULT_DELIMITERS = ",;\t";

    public TypedProperties() {
    }

    public TypedProperties(Properties properties) {
        super(properties);
    }

    public Object clone() {
        TypedProperties typedProperties = (TypedProperties)super.clone();
        return typedProperties;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public Boolean getPropertyAsBoolean(String string) throws RuntimeException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("property value " + string2 + " is not parseable as a boolean");
    }

    public Double getPropertyAsDouble(String string) throws NumberFormatException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return new Double(string2);
    }

    public Integer getPropertyAsInteger(String string) throws NumberFormatException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return new Integer(string2);
    }

    public Long getPropertyAsLong(String string) throws NumberFormatException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return new Long(string2);
    }

    public List getPropertyAsStringList(String string) {
        return this.getPropertyAsStringList(string, DEFAULT_DELIMITERS);
    }

    public List getPropertyAsStringList(String string, String string2) {
        Contract.pre(string2 != null && string2.length() > 0, "delims != null && delims.length() > 0");
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string3 = string3.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2, false);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4 == null || string4.length() <= 0) continue;
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    public void load(Class clazz, String string) throws IOException {
        InputStream inputStream = null;
        if (clazz == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            Contract.pre(inputStream != null, "system reource " + string + " must exist");
        } else {
            inputStream = clazz.getResourceAsStream(string);
            Contract.pre(inputStream != null, "reource " + string + " associated with class " + clazz + " must exist");
        }
        this.load(inputStream);
    }

    public void load(String string) throws FileNotFoundException, IOException {
        Contract.pre(string != null, "fileName not null");
        this.load(new BufferedInputStream(new FileInputStream(string)));
    }

    public String toString() {
        return "TypedProperties";
    }
}

