% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{dplyr-count}
\alias{dplyr-count}
\alias{tally.GroupedGInteractions}
\alias{count.GroupedGInteractions}
\alias{count.GInteractions}
\title{Count or tally GInteractions per group}
\usage{
\method{tally}{GroupedGInteractions}(x, wt = NULL, sort = FALSE, name = NULL)

\method{count}{GroupedGInteractions}(x, ..., wt = NULL, sort = FALSE, name = NULL)

\method{count}{GInteractions}(x, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{A grouped GInteractions object}

\item{wt}{<\code{\link[rlang:args_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables to group
by.}
}
\value{
a \code{S4Vectors::\link[S4Vectors:DataFrame-class]{DataFrame()}}
object, with an added column with the count/tablly per group.
}
\description{
Count or tally GInteractions per group
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30 + +
chr1 11 20 chr1 51 55 + +
chr1 11 30 chr1 51 55 - -
chr1 11 30 chr2 51 60 - -",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2", "strand1", "strand2")
) |> 
  as_ginteractions() |> 
  mutate(score = runif(4), type = c('cis', 'cis', 'cis', 'trans'))

####################################################################
# 1. Tally groups
####################################################################

gi 

gi |> group_by(strand1) |> tally()

gi |> group_by(type) |> tally()

gi |> group_by(type) |> tally(wt = score)

####################################################################
# 2. Count per groups
####################################################################

gi |> count(type)

gi |> group_by(type) |> count(strand1)

gi |> group_by(type, strand1) |> count(wt = score)

}
