% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMultiSignal.R
\name{calcSignalRange}
\alias{calcSignalRange}
\title{Calculate a score range for multiple signals}
\usage{
calcSignalRange(
    data,
    chrom = NULL,
    chromstart = 1,
    chromend = .Machine$integer.max,
    assembly = "hg38",
    negData = FALSE)
}
\arguments{
\item{data}{List of data to be plotted as character values specifying 
multiple bigwig file paths, dataframes in BED format, or
\link[GenomicRanges]{GRanges} objects with metadata column \code{score}.}

\item{chrom}{Chromosome of data region ragne as a string, if range for a 
specific chromosome is desired.}

\item{chromstart}{Integer start position on chromosome to get data range.}

\item{chromend}{Integer end position on chromosome to get data range.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{negData}{A logical value indicating whether any of the data has both
positive and negative scores and the signal range should be adjusted
accordingly. Default value is \code{negData = FALSE}.}
}
\value{
Returns a vector of length 2 with the calculated c(min, max) range.
}
\description{
Calculate a score range for multiple signals
}
\examples{
library("plotgardenerData")
data("GM12878_ChIP_CTCF_signal")
data("IMR90_ChIP_CTCF_signal")
data("GM12878_ChIP_H3K27ac_signal")
data("IMR90_ChIP_H3K27ac_signal")

calcSignalRange(data = list(GM12878_ChIP_CTCF_signal, 
                            GM12878_ChIP_H3K27ac_signal, 
                            IMR90_ChIP_CTCF_signal, 
                            IMR90_ChIP_H3K27ac_signal),
                chrom = "chr21",
                chromstart = 28150000, chromend = 29150000,
                assembly = "hg38", negData = FALSE)

}
