% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{Utils}
\alias{Utils}
\alias{getBasenamePrefix}
\alias{getPathPrefix}
\alias{checkFileExist}
\alias{checkPathExist}
\alias{checkFileCreatable}
\alias{addFileSuffix}
\title{Functions for directory operations}
\usage{
getBasenamePrefix(filepath, words, ...)

getPathPrefix(filepath, words, ...)

checkFileExist(filePath, ...)

checkPathExist(filePath, ...)

checkFileCreatable(filePath, ...)

addFileSuffix(filePath, suffix, ...)
}
\arguments{
\item{filepath}{\code{character} scalar or vector.}

\item{words}{\code{character} scalar.
Remove substring of the path characters starting to match the word}

\item{...}{Additional arguments, currently unused}

\item{filePath}{\code{Character} scalar.}

\item{suffix}{\code{Character} scalar. File suffix.}
}
\value{
\item{getBasenamePrefix}{Get the filepath
basename with removed suffix}

\item{getPathPrefix}{Get the filepath  with removed suffix}

\item{checkFileExist}{(For package developer) Check file is exist.}

\item{checkPathExist}{(For package developer)
Check directory is exist.}

\item{checkFileCreatable}{(For package developer)
Check file creatable.}

\item{addFileSuffix}{(For package developer) Check if file suffix existed and add suffix}
}
\description{
Functions for directory operations
}
\examples{
getBasenamePrefix("aaa/bbb.ccc.ddd","cCc")

getBasenamePrefix("aaa/bbb.ccc.ddd","ddd")

getPathPrefix("aaa/bbb.ccc.ddd","dDd")

getPathPrefix("aaa/bbb.ccc.ddd","ccc")

file.create("test.bed")

checkFileExist("test.bed")

tryCatch({checkFileExist("test.bed1")},error = function(e) e)

dir.create("testdir")

checkPathExist(file.path(getwd(),"testdir"))

tryCatch({checkPathExist(file.path(dirname(getwd()),
"notexistfolder","testdir"))},error = function(e) e)

checkFileCreatable("aaa.bed")

tryCatch({checkFileCreatable("testdir1/aaa.bed")},error = function(e) e)
}
