% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{readPipelineResults}
\alias{readPipelineResults}
\title{readPipelineResults}
\usage{
readPipelineResults(path = NULL, resfiles = NULL)
}
\arguments{
\item{path}{The path (e.g. folder or prefix) to the results. Either `path` 
or `resfiles` should be given.}

\item{resfiles}{A vector of paths to `*.evaluation.rds` files. Either `path` 
or `resfiles` should be given.}
}
\value{
A list of results.
}
\description{
readPipelineResults
}
\examples{
# we produce mock pipeline results:
pip <- mockPipeline()
datasets <- list( ds1=1:3, ds2=c(5,10,15) )
tmpdir1 <- paste0(tempdir(),'/')
res <- runPipeline(datasets, pipelineDef=pip, output.prefix=tmpdir1,
                   alternatives=list() )
# we read the evaluation files:
res <- readPipelineResults(tmpdir1)
}
