% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{mergePipelineResults}
\alias{mergePipelineResults}
\title{mergePipelineResults}
\usage{
mergePipelineResults(..., rr = NULL, verbose = TRUE)
}
\arguments{
\item{...}{Any number of lists of pipeline results, each as produced by 
\code{\link{readPipelineResults}}}

\item{rr}{Alternatively, the pipeline results can be passed as a list (in 
which case `...` is ignored)}

\item{verbose}{Whether to print processing information}
}
\value{
A list of merged pipeline results.
}
\description{
Merges the (non-aggregated) results of any number of runs of `runPipeline`
using the same \code{\link{PipelineDefinition}} (but on different datasets 
and/or using different parameters). First read the different sets of results 
using \code{\link{readPipelineResults}}, and pass them to this function.
}
\examples{
# we produce 2 mock pipeline results:
pip <- mockPipeline()
datasets <- list( ds1=1:3, ds2=c(5,10,15) )
tmpdir1 <- paste0(tempdir(),'/')
res <- runPipeline(datasets, pipelineDef=pip, output.prefix=tmpdir1,
                   alternatives=list() )
alternatives <- list(meth1=c('log2','sqrt'), meth2='cumsum')
tmpdir2 <- paste0(tempdir(),'/')
res <- runPipeline(datasets, alternatives, pip, output.prefix=tmpdir2)
# we read the evaluation files:
res1 <- readPipelineResults(tmpdir1)
res2 <- readPipelineResults(tmpdir2)
# we merge them:
res <- mergePipelineResults(res1,res2)
# and we aggregate:
res <- aggregatePipelineResults(res)
}
