% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serve.R
\name{servePhantasus}
\alias{servePhantasus}
\title{Serve phantasus.}
\usage{
servePhantasus(
  host = getPhantasusConf("host"),
  port = getPhantasusConf("port"),
  staticRoot = getPhantasusConf("static_root"),
  preloadedDir = getPhantasusConf("preloaded_dir"),
  openInBrowser = TRUE,
  quiet = TRUE,
  background = FALSE
)
}
\arguments{
\item{host}{Host to listen.}

\item{port}{Port to listen.}

\item{staticRoot}{Path to static files with phantasus.js
(on local file system).}

\item{preloadedDir}{Full path to directory with preloaded files.}

\item{openInBrowser}{Boolean value which states if application will be
automatically loaded in default browser.}

\item{quiet}{Boolean value which states whether the connection log should
be hidden (default: TRUE)}

\item{background}{Boolean value which states whether the server should be started in background (default: FALSE)}
}
\value{
A handle to the server as returned by `httpuv::startServer`
}
\description{
\code{servePhantasus} starts http server handling phantasus static files
    and opencpu server.
}
\examples{
\dontrun{
s <- servePhantasus(background=FALSE)
s$stop()
}

httpuv::stopAllServers() # can be used if handle is lost
}
