% Generated by roxygen2 (4.0.0): do not edit by hand
\name{plotArrayImage}
\alias{plotArrayImage}
\alias{plotArrayResiduals}
\title{Plot microarray images}
\usage{
plotArrayImage(peptideSet, array.index = NULL, low = "white",
  high = "steelblue", ask = dev.interactive(orNone = TRUE) & 1 <
  length(array.index))

plotArrayResiduals(peptideSet, array.index = NULL, smooth = FALSE,
  low = "blue", high = "red", ask = dev.interactive(orNone = TRUE) & 1 <
  length(array.index))
}
\arguments{
\item{peptideSet}{A \code{peptideSet} object. The object must contain all the
original probes. See details below.}

\item{array.index}{A vector subsetting \code{exprs(peptideSet)}, indicating
which slides to plot}

\item{smooth}{A \code{logical}, a 2D spatial smoother is applied to residuals,
the fitted residuals are plotted.}

\item{low}{A \code{character} string. The color of the lowest slide intensity.
passed to \code{scale_fill_gradient2}.
the fitted residuals are plotted.}

\item{high}{A \code{character} string. The color of the highest slide intensity.
passed to \code{scale_fill_gradient2}.}

\item{ask}{A \code{logical}. If TRUE, the user is asked before each plot. See
\code{par(ask=.)}.}
}
\description{
Plot a color image of the intensities on a slide. These plots are helpful to
diagnose spatial abnormalities.
}
\details{
The most coherent results are achieved when the \code{peptideSet} object is
read with \code{makePeptideSet} with empty.control.list = NULL and rm.control.list
= NULL
}
\examples{
## This example curated from the vignette -- please see vignette("pepStat")
## for more information
if (require("pepDat")) {

  ## Get example GPR files + associated mapping file
  dirToParse <- system.file("extdata/gpr_samples", package = "pepDat")
  mapFile <- system.file("extdata/mapping.csv", package = "pepDat")

  ## Make a peptide set
  pSet <- makePeptideSet(files = NULL, path = dirToParse,
                         mapping.file = mapFile, log=TRUE)

  ## Plot array images -- useful for quality control
  plotArrayImage(pSet, array.index = 1)
  plotArrayResiduals(pSet, array.index = 1, smooth = TRUE)

  ## Summarize peptides, using pep_hxb2 as the position database
  data(pep_hxb2)
  psSet <- summarizePeptides(pSet, summary = "mean", position = pep_hxb2)

  ## Normalize the peptide set
  pnSet <- normalizeArray(psSet)

  ## Smooth
  psmSet <- slidingMean(pnSet, width = 9)

  ## Make calls
  calls <- makeCalls(psmSet, freq = TRUE, group = "treatment",
                     cutoff = .1, method = "FDR", verbose = TRUE)

  ## Produce a summary of the results
  summary <- restab(psmSet, calls)

}
}
\author{
Gregory Imholte
}

