% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca2go.R
\name{pca2go}
\alias{pca2go}
\title{Functional interpretation of the principal components}
\usage{
pca2go(
  se,
  pca_ngenes = 10000,
  annotation = NULL,
  inputType = "geneSymbol",
  organism = "Mm",
  ensToGeneSymbol = FALSE,
  loadings_ngenes = 500,
  background_genes = NULL,
  scale = FALSE,
  return_ranked_gene_loadings = FALSE,
  annopkg = NULL,
  ...
)
}
\arguments{
\item{se}{A \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}} object, with data in \code{assay(se)},
produced for example by either \code{\link[DESeq2:rlog]{DESeq2::rlog()}} or
\code{\link[DESeq2:varianceStabilizingTransformation]{DESeq2::varianceStabilizingTransformation()}}}

\item{pca_ngenes}{Number of genes to use for the PCA}

\item{annotation}{A \code{data.frame} object, with row.names as gene identifiers (e.g. ENSEMBL ids)
and a column, \code{gene_name}, containing e.g. HGNC-based gene symbols}

\item{inputType}{Input format type of the gene identifiers. Will be used by the routines of \code{topGO}}

\item{organism}{Character abbreviation for the species, using \code{org.XX.eg.db} for annotation}

\item{ensToGeneSymbol}{Logical, whether to expect ENSEMBL gene identifiers, to convert to gene symbols
with the \code{annotation} provided}

\item{loadings_ngenes}{Number of genes to extract the loadings (in each direction)}

\item{background_genes}{Which genes to consider as background.}

\item{scale}{Logical, defaults to FALSE, scale values for the PCA}

\item{return_ranked_gene_loadings}{Logical, defaults to FALSE. If TRUE, simply returns
a list containing the top ranked genes with hi loadings in each PC and in each direction}

\item{annopkg}{String containing the name of the organism annotation package. Can be used to
override the \code{organism} parameter, e.g. in case of alternative identifiers used
in the annotation package (Arabidopsis with TAIR)}

\item{...}{Further parameters to be passed to the topGO routine}
}
\value{
A nested list object containing for each principal component the terms enriched
in each direction. This object is to be thought in combination with the displaying feature
of the main \code{\link[=pcaExplorer]{pcaExplorer()}} function
}
\description{
Extracts the genes with the highest loadings for each principal component, and
performs functional enrichment analysis on them using routines and algorithms from
the \code{topGO} package
}
\examples{
library("airway")
library("DESeq2")
data("airway", package = "airway")
airway
dds_airway <- DESeqDataSet(airway, design= ~ cell + dex)
\dontrun{
rld_airway <- rlogTransformation(dds_airway)
# constructing the annotation object
anno_df <- data.frame(gene_id = rownames(dds_airway),
                      stringsAsFactors = FALSE)
library("AnnotationDbi")
library("org.Hs.eg.db")
anno_df$gene_name <- mapIds(org.Hs.eg.db,
                            keys = anno_df$gene_id,
                            column = "SYMBOL",
                            keytype = "ENSEMBL",
                            multiVals = "first")
rownames(anno_df) <- anno_df$gene_id
bg_ids <- rownames(dds_airway)[rowSums(counts(dds_airway)) > 0]
library(topGO)
pca2go_airway <- pca2go(rld_airway,
                        annotation = anno_df,
                        organism = "Hs",
                        ensToGeneSymbol = TRUE,
                        background_genes = bg_ids)
}

}
