% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_annotation.R
\name{get_annotation_orgdb}
\alias{get_annotation_orgdb}
\title{Get an annotation data frame from org db packages}
\usage{
get_annotation_orgdb(dds, orgdb_species, idtype, key_for_genenames = "SYMBOL")
}
\arguments{
\item{dds}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object}

\item{orgdb_species}{Character string, named as the \code{org.XX.eg.db}
package which should be available in Bioconductor}

\item{idtype}{Character, the ID type of the genes as in the row names of
\code{dds}, to be used for the call to \code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::mapIds()}}}

\item{key_for_genenames}{Character, corresponding to the column name for the
key in the orgDb package containing the official gene name (often called
gene symbol).
This parameter defaults to "SYMBOL", but can be adjusted in case the key is not
found in the annotation package (e.g. for \code{org.Sc.sgd.db}).}
}
\value{
A data frame for ready use in \code{pcaExplorer}, retrieved from the
org db packages
}
\description{
Get an annotation data frame from org db packages
}
\examples{
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
                                             colData = colData(airway),
                                             design = ~dex+cell)
anno_df <- get_annotation_orgdb(dds_airway, "org.Hs.eg.db", "ENSEMBL")
head(anno_df)
}
