% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superPC_pathway_tScores.R
\name{pathway_tScores}
\alias{pathway_tScores}
\title{Calculate pathway-specific Student's \eqn{t}-scores for supervised PCA}
\usage{
pathway_tScores(
  pathway_vec,
  geneArray_df,
  response_mat,
  responseType = c("survival", "regression", "categorical"),
  n.threshold = 20,
  numPCs = 1,
  min.features = 3
)
}
\arguments{
\item{pathway_vec}{A character vector of the measured -Omes in the chosen
gene pathway. These should match a subset of the rownames of the gene
array.}

\item{geneArray_df}{A "tall" pathway data frame (\eqn{p \times N}). Each
subject or tissue sample is a column, and the rows are the -Ome
measurements for that sample.}

\item{response_mat}{A response matrix corresponding to \code{responseType}.
For \code{"regression"} and \code{"categorical"}, this will be an
\eqn{N \times 1} matrix of response values. For \code{"survival"}, this
will be an \eqn{N \times 2} matrix with event times in the first column
and observed event indicator in the second.}

\item{responseType}{A character string. Options are \code{"survival"},
\code{"regression"}, and \code{"categorical"}.}

\item{n.threshold}{The number of bins into which to split the feature scores
in the \code{fit} object returned internally by the
\code{\link{superpc.train}} function.}

\item{numPCs}{The number of PCs to extract from the pathway.}

\item{min.features}{What is the smallest number of genes allowed in each
pathway? This argument must be kept constant across all calls to this
function which use the same pathway list. Defaults to 3.}
}
\value{
A matrix with \code{numPCs} rows and \code{n.threshold} columns.
   The matrix values are model \eqn{t}-statisics for each PC included (rows)
   at each threshold level (columns).
}
\description{
Extract principal components (PCs) from the gene pathway, and
   return the test statistics associated with the first \code{numPCs}
   principal components at a set of threshold values.
}
\details{
This is a wrapper function to call \code{\link{superpc.train}}
   and \code{\link{superpc.st}}. This wrapper is designed to facilitate
   apply calls (in parallel or serially) of these two functions over a list
   of gene pathways. When \code{numPCs} is equal to 1, we recommend using a
   simplify-style apply variant, such as \code{sapply} (shown in
   \code{\link[base]{lapply}}) or \code{parSapply} (shown in
   \code{\link[parallel]{clusterApply}}), then transposing the resulting
   matrix.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Use SuperPCA_pVals() instead

\dontrun{
  data("colon_pathwayCollection")
  data("colonSurv_df")

  colon_OmicsSurv <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "surv"
  )

  asthmaGenes_char <-
    getTrimPathwayCollection(colon_OmicsSurv)[["KEGG_ASTHMA"]]$IDs
  resp_mat <- matrix(
    c(getEventTime(colon_OmicsSurv), getEvent(colon_OmicsSurv)),
    ncol = 2
  )

  pathway_tScores(
    pathway_vec = asthmaGenes_char,
    geneArray_df = t(getAssay(colon_OmicsSurv)),
    response_mat = resp_mat,
    responseType = "survival"
  )
}

}
\seealso{
\code{\link{superpc.train}}; \code{\link{superpc.st}}
}
\keyword{internal}
