% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOmics_CheckAssay.R
\name{CheckAssay}
\alias{CheckAssay}
\title{Check an Input Assay}
\usage{
CheckAssay(df, removeNear0 = TRUE, epsilon = 10^-6)
}
\arguments{
\item{df}{An assay data frame supplied to the \code{\link{CreateOmics}}
function. The first column is assumed to be the sample IDs, and will be
ignored. See \code{\link{CheckSampleIDs}} for checking sample IDs.}

\item{removeNear0}{Should columns of \code{df} with variance near 0 be
removed? Defaults to \code{TRUE}.}

\item{epsilon}{Threshold to consider the variance of a column equal to 0.
Defaults to 0.000001.}
}
\value{
The same data frame, without features with 0 variance, \strong{if}
   that data frame passes all checks.
}
\description{
Check the classes, dimensions, missingness, feature variance,
  feature type, and feature names of a data frame.
}
\details{
This function checks that the data frame is not a matrix, that the
   data frame has more columns than rows (tidy genomic data), that the data
   frame contains no missing or character values, that no features of the
   data frame have variance less than \code{epsilon} (and removes such
   features if \code{removeNear0 = TRUE}), and checks the data frame for
   valid column names.
}
\examples{
 # DO NOT CALL THIS FUNCTION DIRECTLY. CALL FROM WITHIN CreateOmics().

\dontrun{
 data("colonSurv_df")
 CheckAssay(colonSurv_df[, -(1:3)])
}

}
\keyword{internal}
