% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_functions.R
\name{topedges}
\alias{topedges}
\title{Top edges}
\usage{
topedges(x, count = NA, cutoff = 2, networks = c("coregulation",
  "cooperation", "regulatory"))
}
\arguments{
\item{x}{an object of class "panda"}

\item{count}{an optional integer indicating number of top edges to be included in regulatory network.}

\item{cutoff}{an optional numeric indicating the z-score edge weight cutoff to be used to identify edges. Default is 2.0.  Not used if count is not NA.}

\item{networks}{an optional vector specifying which networks to be included in output.  May be any combination of c("coregulation","cooperation","regulatory").}
}
\value{
An object of class "panda" containing binary matrices indicating the existence of an edge between two nodes.  For regulatory network the matrix indicates an edge between a transcription factor (row) and a gene (column)
}
\description{
topedges gets a network from a panda obj with a specified cutoff based on magnitude of edgeweight.
}
\examples{
\donttest{
data(pandaToyData)
pandaRes <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.001,progress=TRUE)
topPandaRes <- topedges(pandaRes,1000)
}
data(pandaResult)
topPandaRes <- topedges(pandaResult,1000)
}
\keyword{keywords}
