% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_functions.R
\name{panda}
\alias{panda}
\title{Passing Messages between Biological Networks to Refine Predicted Interactions}
\usage{
panda(motif, expr = NULL, ppi = NULL, alpha = 0.1, hamming = 0.001,
  iter = NA, output = c("regulatory", "coexpression", "cooperative"),
  zScale = TRUE, progress = FALSE, randomize = c("None",
  "within.gene", "by.gene"), cor.method = "pearson",
  scale.by.present = FALSE, edgelist = FALSE,
  remove.missing.ppi = FALSE, remove.missing.motif = FALSE,
  remove.missing.genes = FALSE, mode = "union")
}
\arguments{
\item{motif}{A motif dataset, a data.frame, matrix or exprSet containing 3 columns.
Each row describes an motif associated with a transcription factor (column 1) a
gene (column 2) and a score (column 3) for the motif.}

\item{expr}{An expression dataset, as a genes (rows) by samples (columns) data.frame}

\item{ppi}{A Protein-Protein interaction dataset, a data.frame containing 3 columns.
Each row describes a protein-protein interaction between transcription factor 1(column 1),
transcription factor 2 (column 2) and a score (column 3) for the interaction.}

\item{alpha}{value to be used for update variable, alpha (default=0.1)}

\item{hamming}{value at which to terminate the process based on hamming distance (default 10^-3)}

\item{iter}{sets the maximum number of iterations PANDA can run before exiting.}

\item{output}{a vector containing which networks to return.  Options include "regulatory",
"coregulatory", "cooperative".}

\item{zScale}{Boolean to indicate use of z-scores in output.  False will use [0,1] scale.}

\item{progress}{Boolean to indicate printing of output for algorithm progress.}

\item{randomize}{method by which to randomize gene expression matrix.  Default "None".  Must
be one of "None", "within.gene", "by.genes".  "within.gene" randomization scrambles each row
of the gene expression matrix, "by.gene" scrambles gene labels.}

\item{cor.method}{Correlation method, default is "pearson".}

\item{scale.by.present}{Boolean to indicate scaling of correlations by percentage of positive samples.}

\item{edgelist}{Boolean to indicate if edge lists instead of matrices should be returned.}

\item{remove.missing.ppi}{Boolean to indicate whether TFs in the PPI but not in the motif data should be
removed. Only when mode=='legacy'.}

\item{remove.missing.motif}{Boolean to indicate whether genes targeted in the motif data but not the
expression data should be removed. Only when mode=='legacy'.}

\item{remove.missing.genes}{Boolean to indicate whether genes in the expression data but lacking
information from the motif prior should be removed. Only when mode=='legacy'.}

\item{mode}{The data alignment mode. The mode 'union' takes the union of the genes in the expression matrix and the motif
and the union of TFs in the ppi and motif and fills the matrics with zeros for nonintersecting TFs and gens, 'intersection' 
takes the intersection of genes and TFs and removes nonintersecting sets, 'legacy' is the old behavior with version 1.19.3.
#' Parameters remove.missing.ppi, remove.missingmotif, remove.missing.genes work only with mode=='legacy'.}
}
\value{
An object of class "panda" containing matrices describing networks achieved by convergence
with PANDA algorithm.\cr
"regNet" is the regulatory network\cr
"coregNet" is the coregulatory network\cr
"coopNet" is the cooperative network
}
\description{
This function runs the PANDA algorithm
}
\examples{
data(pandaToyData)
pandaRes <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.1,progress=TRUE)
}
\references{
Glass K, Huttenhower C, Quackenbush J, Yuan GC. Passing Messages Between Biological Networks
to Refine Predicted Interactions. PLoS One. 2013 May 318(5):e64832.
}
\keyword{keywords}
