% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P_graph.R
\name{P_graph}
\alias{P_graph}
\title{Build Probability-Based Network}
\usage{
P_graph(
  expmat,
  net,
  sep = 5,
  method = c("difference", "mi"),
  null = NULL,
  threshold = 0.001
)
}
\arguments{
\item{expmat}{(matrix) Gene expression matrix.}

\item{net}{(data.frame) Network, with "reg" and "target" in column name.}

\item{sep}{(numeric) Number of bins for calculating marginal/joint
probability.}

\item{method}{(character) Method for calculating probability-based distance,
either PXY-PXPY ("difference") or mutual information ("mi").}

\item{null}{(ecdf) Null distribution of probability-based distance. Either
from random interactions by P_null function, or all interactions in net.}

\item{threshold}{(numeric) P-value threshold for filtering interactions in
net.}
}
\value{
(igraph) Network graph with "pvalue" and "direction", and "pagerank"
as edge/vertex attributes.
}
\description{
Build probability-based regulator-target interaction network.
}
\examples{
library(bcellViper)
data(bcellViper)
dset <- exprs(dset)
net <- do.call(rbind, lapply(1:10, function(i, regulon){
  data.frame(reg=rep(names(regulon)[i], 10),
             target=names(regulon[[i]][[1]])[1:10],
             direction=rep(1, 10),
             stringsAsFactors = FALSE)}, regulon=regulon))
P_graph(dset, net, method="difference", null=NULL, threshold=0.05)

}
\author{
DING, HONGXU (hd2326@columbia.edu)
}
