% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyTirMatches.R
\name{identifyTirMatches}
\alias{identifyTirMatches}
\title{Identify Terminal Inverted Repeat Matches}
\usage{
identifyTirMatches(
  tirSeq,
  Genome,
  mismatch = 0,
  strand = "*",
  tsdLength,
  fixed = TRUE
)
}
\arguments{
\item{tirSeq}{A \code{\link[Biostrings:DNAString-class]{DNAString}} 
object to be searched for.}

\item{Genome}{A \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
object containing the 
\code{\link[Biostrings:DNAString-class]{DNAString}} 
objects to be searched.}

\item{mismatch}{The allowable mismatch between \code{tirSeq} and a 
given slice of \code{Genome}. Includes indels.}

\item{strand}{The directionality of the search string ("+" or "-"). Note
that this does affect the search for tirSeqs, if you wish 
to search the reverse strand you should use the reverse 
complement of your sequence.}

\item{tsdLength}{Integer referring to the length of the flanking TSD region.}

\item{fixed}{Logical that will be passed to the `fixed` argument of 
\code{\link[Biostrings]{matchPattern}}. Determines the behaviour of IUPAC
ambiguity codes when searching for TIR sequences.}
}
\value{
A dataframe, \code{tirMatches}, containing identified 
matches. The dataframe is in the format generated by 
\code{\link{packSearch}}.
}
\description{
Searches a \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
for potential TIRs based on sequence similarity.
}
\details{
Called by \code{\link{packSearch}}. Used by 
\code{\link{packSearch}} as an initial filtering stage. 
\code{\link[Biostrings]{matchPattern}} from Biostrings 
is used for pattern matching. It is recommended to use 
the general pipeline function \code{\link{packSearch}} 
for identification of potential pack elements, however 
each stage may be called individually.
}
\examples{
data(arabidopsisThalianaRefseq)

forwardMatches <- identifyTirMatches(
    Biostrings::DNAString("CACTACAA"),
    arabidopsisThalianaRefseq,
    tsdLength = 3,
    strand = "+"
)

}
\seealso{
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}},
\code{\link{packSearch}}, \code{\link[Biostrings]{matchPattern}},
\code{\link[Biostrings:DNAString-class]{DNAString}}
}
\author{
Jack Gisby
}
