% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPackSeqs.R
\name{getPackSeqs}
\alias{getPackSeqs}
\title{Extract Sequences of Pack-TYPE Elements}
\usage{
getPackSeqs(packMatches, Genome, output = "DNAStringSet")
}
\arguments{
\item{packMatches}{A dataframe containing genomic ranges and names referring 
to sequences to be extracted. This dataframe is in the format 
produced by coercing a 
\code{link[GenomicRanges:GRanges-class]{GRanges}} 
object to a dataframe: \code{data.frame(GRanges)}. 

Must contain the following features:
\itemize{
    \item start - the predicted element's start base 
    sequence position.
    \item end - the predicted element's end base 
    sequence position.
    \item seqnames - character string referring to the 
    sequence name in \code{Genome} to which \code{start} 
    and \code{end} refer to.
}}

\item{Genome}{A DNAStringSet object containing sequences referred to 
in \code{packMatches} (the object originally used to 
predict the transposons \code{\link{packSearch}}).}

\item{output}{The type of object to be returned:
\itemize{
    \item output = "DNAStringSet", returns a 
    \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
    object (default).
    \item output = "character", returns a 
    \code{character} vector.
}}
}
\value{
transposon sequences extracted from \code{packMatches}. 
At default returns the sequences as a 
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
or, if \code{output} is set to "character", returns a 
character vector.
}
\description{
Method to quickly extract the sequences of predicted 
Pack-TYPE elements (as created by \code{\link{packSearch}}).
}
\examples{
data(arabidopsisThalianaRefseq)

packMatches <- packSearch(
    Biostrings::DNAString("CACTACAA"),
    arabidopsisThalianaRefseq,
    elementLength = c(300, 3500),
    tsdLength = 3
)

packSeqs <- getPackSeqs(packMatches, arabidopsisThalianaRefseq)

}
\seealso{
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}},
\code{\link{packSearch}},
\code{\link[Biostrings:XString-class]{DNAString}}
}
\author{
Jack Gisby
}
