% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotConsProfiles}
\alias{plotConsProfiles}
\title{Plot marker consensus profiles.}
\usage{
plotConsProfiles(object, order = NULL, plot = TRUE)
}
\arguments{
\item{object}{A \code{matrix} containing marker consensus profiles as output from
\code{\link[=mrkConsProfiles]{mrkConsProfiles()}}.}

\item{order}{Order for markers (optional).}

\item{plot}{A \code{logical(1)} defining whether the heatmap should be plotted.
Default is \code{TRUE}.}
}
\value{
Invisibly returns \code{ggplot2} object.
}
\description{
The function plots marker consensus profiles obtained from mrkConsProfile
}
\examples{
library("pRolocdata")
data(E14TG2aS1)
hc <- mrkHClust(E14TG2aS1, plot = FALSE)
mm <- getMarkerClasses(E14TG2aS1)
ord <- levels(factor(mm))[order.dendrogram(hc)]
fmat <- mrkConsProfiles(E14TG2aS1)
plotConsProfiles(fmat, order = ord)
}
\author{
Tom Smith
}
