% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingBayes.R
\name{nicheMeans2D}
\alias{nicheMeans2D}
\title{Uncertainty plot organelle means}
\usage{
nicheMeans2D(
  object,
  params,
  priors,
  dims = c(1, 2),
  fcol = "markers",
  aspect = 0.5
)
}
\arguments{
\item{object}{A valid object of class \code{MSnset}}

\item{params}{A valid object of class \code{MCMCParams} that has been
processed and checked for convergence}

\item{priors}{The prior that were used in the model}

\item{dims}{The PCA dimension in which to project he data, default is
\code{c(1,2)}}

\item{fcol}{The columns of the feature data which contain the marker data.}

\item{aspect}{A argument to change the plotting aspect of the PCA}
}
\value{
Used for side effect of producing plot. Invisibily returns an ggplot
    object that can be further manipulated
}
\description{
Produces a pca plot with uncertainty in organelle means projected
onto the PCA plot with contours.
}
\examples{
\dontrun{
library("pRolocdata")
data("tan2009r1")

tanres <- tagmMcmcTrain(object = tan2009r1)
tanres <- tagmMcmcProcess(tanres)
tan2009r1 <- tagmMcmcPredict(object = tan2009r1, params = tanres, probJoint = TRUE)
myparams <- chains(e14Tagm_converged_pooled)[[1]]
myparams2 <- chains(mcmc_pool_chains(tanres))[[1]]
priors <- tanres@priors
pRoloc:::nicheMeans2D(object = tan2009r1, params = myparams2, priors = priors)
}
}
\author{
Oliver M. Crook <omc25@cam.ac.uk>
}
