% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-ksvm.R
\name{ksvmClassification}
\alias{ksvmClassification}
\alias{ksvmPrediction}
\title{ksvm classification}
\usage{
ksvmClassification(
  object,
  assessRes,
  scores = c("prediction", "all", "none"),
  cost,
  fcol = "markers",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{assessRes}{An instance of class
\code{"\linkS4class{GenRegRes}"}, as generated by
\code{\link{ksvmOptimisation}}.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{cost}{If \code{assessRes} is missing, a \code{cost} must be
provided.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{...}{Additional parameters passed to \code{\link{ksvm}} from
package \code{kernlab}.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} with
    \code{ksvm} and \code{ksvm.scores} feature variables storing
    the classification results and scores respectively.
}
\description{
Classification using the support vector
machine algorithm.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- ksvmOptimisation(dunkley2006, cost = 2^seq(-1,4,5), times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- ksvmClassification(dunkley2006, params)
getPredictions(res, fcol = "ksvm")
getPredictions(res, fcol = "ksvm", t = 0.75)
plot2D(res, fcol = "ksvm")
}
\author{
Laurent Gatto
}
