% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{filterBinMSnSet}
\alias{filterBinMSnSet}
\title{Filter a binary MSnSet}
\usage{
filterBinMSnSet(object, MARGIN = 2, t, q, verbose = TRUE)
}
\arguments{
\item{object}{An \code{MSnSet}}

\item{MARGIN}{1 or 2. Default is 2.}

\item{t}{Rows/columns that have \code{t} or less \code{1}s, it
will be filtered out. When \code{t} and \code{q} are missing,
default is to use \code{t = 1}.}

\item{q}{If a row has a higher quantile than defined by \code{q},
it will be filtered out.}

\item{verbose}{A \code{logical} defining of a message is to be
printed. Default is \code{TRUE}.}
}
\value{
A filtered \code{MSnSet}.
}
\description{
Removes columns or rows that have a certain proportion or absolute
number of 0 values.
}
\examples{
set.seed(1)
m <- matrix(sample(0:1, 25, replace=TRUE), 5)
m[1, ] <- 0
m[, 1] <- 0
rownames(m) <- colnames(m) <- letters[1:5]
fd <- data.frame(row.names = letters[1:5])
x <- MSnSet(exprs = m, fData = fd, pData = fd)
exprs(x)
## Remove columns with no 1s
exprs(filterBinMSnSet(x, MARGIN = 2, t = 0))
## Remove columns with one 1 or less
exprs(filterBinMSnSet(x, MARGIN = 2, t = 1))
## Remove columns with two 1s or less
exprs(filterBinMSnSet(x, MARGIN = 2, t = 2))
## Remove columns with three 1s 
exprs(filterBinMSnSet(x, MARGIN = 2, t = 3))
## Remove columns that have half or less of 1s
exprs(filterBinMSnSet(x, MARGIN = 2, q = 0.5))
}
\seealso{
\code{\link{zerosInBinMSnSet}},
    \code{\link{filterZeroCols}}, \code{\link{filterZeroRows}}.
}
\author{
Laurent Gatto
}
