% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_orthologs_gprofiler.R
\name{map_orthologs_gprofiler}
\alias{map_orthologs_gprofiler}
\title{Map orthologs: gprofiler}
\usage{
map_orthologs_gprofiler(
  genes,
  input_species,
  output_species = "human",
  filter_na = FALSE,
  mthreshold = Inf,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{genes}{Gene list.}

\item{input_species}{Name of the input species (e.g., "mouse","fly").
Use \link[orthogene]{map_species} to return a full list
of available species.}

\item{output_species}{Name of the output species (e.g. "human","chicken").
Use \link[orthogene]{map_species} to return a full list
 of available species.}

\item{filter_na}{Logical indicating whether to
filter out results without a corresponding target name.
(\emph{DEFAULT} is \code{FALSE}, so that \code{NA}s
can be handled by \pkg{orthogene}).}

\item{mthreshold}{Maximum number of ortholog names per gene to show.
Passed to \link[gprofiler2]{gorth}.
Only used when \code{method="gprofiler"} (\emph{DEFAULT : }\code{Inf}).}

\item{verbose}{Print messages.}

\item{...}{Additional arguments to be passed to
\link[gprofiler2]{gorth}.}
}
\value{
Ortholog map \code{data.frame}
}
\description{
Map orthologs from one species to another
using \link[gprofiler2]{gorth}.
}
\details{
"\code{mthreshold} is used to set the maximum number
of ortholog names per gene to show. This is useful to handle
 the problem of having many orthologs per gene
 (most of them uninformative). The function tries to
  find the most informative by selecting the most popular ones."\cr
~ From
\href{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}{
 \code{gprofiler2} vignette}\cr

Available namespaces for the \code{numeric_ns} argument can be found
\href{https://biit.cs.ut.ee/gprofiler/page/namespaces-list}{here}.
}
\keyword{internal}
