% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_species.R
\name{map_species}
\alias{map_species}
\title{Standardise species names}
\usage{
map_species(
  species = NULL,
  search_cols = c("display_name", "id", "scientific_name", "taxonomy_id"),
  output_format = c("scientific_name", "id", "display_name", "taxonomy_id", "version",
    "scientific_name_formatted"),
  method = c("homologene", "gprofiler", "babelgene"),
  remove_subspecies = TRUE,
  remove_subspecies_exceptions = c("Canis lupus familiaris"),
  use_local = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{species}{Species query
(e.g. "human", "homo sapiens", "hsapiens", or 9606).
If given a list, will iterate queries for each item.
Set to \code{NULL} to return all species.}

\item{search_cols}{Which columns to search for
\code{species} substring in
metadata \href{https://biit.cs.ut.ee/gprofiler/api/util/organisms_list}{
API}.}

\item{output_format}{Which column to return.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{remove_subspecies}{Only keep the first two taxonomic levels:
e.g. "Canis lupus familiaris" --> "Canis lupus"}

\item{remove_subspecies_exceptions}{Selected species to ignore when 
\code{remove_subspecies=TRUE}.
e.g. "Canis lupus familiaris" --> "Canis lupus familiaris"}

\item{use_local}{If \code{TRUE} \emph{default},
\link[orthogene]{map_species}
uses a locally stored version of the species metadata table
instead of pulling directly from the gprofiler API.
Local version may not be fully up to date,
but should suffice for most use cases.}

\item{verbose}{Print messages.}
}
\value{
Species ID of type \code{output_format}
}
\description{
Search \code{gprofiler} database for species
that match the input text string.
Then translate to a standardised species ID.
}
\examples{
ids <- map_species(species = c(
    "human", 9606, "mus musculus",
    "fly", "C elegans"
))
}
