% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wasserCostFunction.R
\name{wasserCostFunction}
\alias{wasserCostFunction}
\title{wasserCostFunction}
\usage{
wasserCostFunction(j, i, cytometries, equal.weights = FALSE)
}
\arguments{
\item{j}{An entry of the list of partitions.}

\item{i}{An entry of the list of partitions.}

\item{cytometries}{The list of partitions.}

\item{equal.weights}{If True, weights assigned to every cluster in a partion are
uniform (1/number of clusters) when calculating the similarity distance.
If False, weights assigned to clusters are the proportions of points in every
 cluster compared to the total amount of points in the partition.}
}
\value{
A double giving the value of the similarity distance.
}
\description{
Calculates the similarity distance between elements j and i of a list of partitions.
}
\examples{
# # We construct a simple database selecting only some of the Cytometries and some cell types for simplicity and for a better visualisation.
database <- buildDatabase(
  dataset_names = paste0('Cytometry', c(2:5, 7:9, 12:17, 19, 21)),
    population_ids = c('Monocytes', 'CD4+CD8-', 'Mature SIg Kappa', 'TCRgd-'))

templates.optimalFlow <- optimalFlowTemplates(database = database, templates.number = 5,
cl.paral = 1)
print(wasserCostFunction(1, 2, list(templates.optimalFlow$database.elliptical[[1]],
 templates.optimalFlow$database.elliptical[[2]])))

}
