% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_primer_coverage.R
\name{update.cvg.data}
\alias{update.cvg.data}
\title{Update Coverage Information.}
\usage{
\method{update}{cvg.data}(
  filtered.df,
  sel,
  template.df,
  mode = c("on_target", "off_target"),
  active.constraints
)
}
\arguments{
\item{filtered.df}{Primer data frame.}

\item{sel}{List with indices of covered templates to be retained, one list with template indices to keep per primer.}

\item{template.df}{Template data frame.}

\item{mode}{Either \code{on_target} to filter on-target binding events
or \code{off_target} to filter off-target binding events. The corresponding
\code{sel} argument should be different.}

\item{active.constraints}{The active coverage constraints.}
}
\value{
A primer data frame with updated coverage information.
}
\description{
Updates the coverage-related columns in the input primer data frame.
Does not modify the entries of template-specific coverage columns
such as primer efficiency (comma-separated values).
}
\details{
Removes all coverage events of templates whose index is not in \code{sel}.
}
\keyword{internal}
