% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_primers_tree.R
\name{create.primers.tree}
\alias{create.primers.tree}
\title{Tree-based Initialization of Primers.}
\usage{
create.primers.tree(
  seqs,
  seq.IDs,
  seq.groups,
  start,
  end,
  primer.lengths,
  allowed.region.definition,
  max.degen,
  conservation,
  sample = "",
  identifier = "",
  updateProgress = NULL
)
}
\arguments{
\item{seqs}{Template sequences.}

\item{seq.IDs}{Identifiers of template sequences.}

\item{seq.groups}{Group identifiers of template sequences.}

\item{start}{For each template the start of the interval where primers 
should be created.}

\item{end}{For each template the end of the interval where primers
should be created.}

\item{primer.lengths}{Vector of desired primer lengths.}

\item{allowed.region.definition}{Definition of allowed regions.}

\item{max.degen}{Maximal degeneracy of primers.}

\item{conservation}{Required conservation of template regions considered
for the generation of primers. Conservation identifies the top conserved 
percentile of possible primers.}

\item{sample}{Sample name for the analysis.}

\item{identifier}{Identifier (e.g. for directionality).}

\item{updateProgress}{Shiny progress object.}
}
\value{
A vector with initialized primers.
}
\description{
Creates a set of candidate primers using a tree-based algorithm.
}
\details{
First, primers are aligned and their sequence similarity is determined to
compute a phylogenetic tree using hierarchical clustering.
Next, the tree is traversed from leaves to top in order to identify
groups of primers that can be merged (consensus) without exceeding the maximum
degeneracy of primers.
}
\keyword{internal}
