% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_melting_temperature.R
\name{call.melt}
\alias{call.melt}
\title{Thermodynamic melting temperature computations.}
\usage{
call.melt(
  primers,
  complements,
  primer_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc
)
}
\arguments{
\item{primers}{Character vector of primer strings.}

\item{complements}{Character vector with complement sequences
corresponding to \code{primers}.}

\item{primer_conc}{Primer concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris buffer concentration.}
}
\value{
Melting temperature data frame.
}
\description{
Computes the melting temperature for the input primers.
}
\references{
Le Novère N. (2001). MELTING, computing the 
melting temperature of nucleic acid duplex. Bioinformatics, 17: 1226-1227. 
Dumousseau M., Rodriguez N., Juty N., Le Novère N. (2012) MELTING, 
a flexible platform to predict the melting temperatures of nucleic acids. 
BMC Bioinformatics, 13: 101.
}
\keyword{internal}
