% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym2CellOnto.R
\name{sym2CellOnto}
\alias{sym2CellOnto}
\title{use Cell Ontology and Protein Ontology to identify cell-type defining conditions in which a given gene is named}
\usage{
sym2CellOnto(sym, cl, pr)
}
\arguments{
\item{sym}{gene symbol, must be used in protein ontology as a PRO:DNx exact match token}

\item{cl}{result of getOnto("cellOnto")}

\item{pr}{result of getOnto("PROnto")}
}
\value{
DataFrame if any hits are found.  A field 'cond' abbreviates the identified
conditions: (has/lacks)PMP (plasma membrane part) (hi/lo)PMAmt (plasma membrane amount), (has/lacks)Part.
}
\description{
use Cell Ontology and Protein Ontology to identify cell-type defining conditions in which a given gene is named
}
\note{
Currently just checks for *plasma_membrane_part, *plasma_membrane_amount, and *Part conditions.
}
\examples{
if (!exists("cl")) cl = getOnto("cellOnto")
if (!exists("pr")) pr = getOnto("PROnto")
sym2CellOnto("ITGAM", cl, pr)
sym2CellOnto("FOXP3", cl, pr)
}
