% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLextend.R
\name{ldfToTerms}
\alias{ldfToTerms}
\title{use output of cyclicSigset to generate a series of character vectors constituting OBO terms}
\usage{
ldfToTerms(
  ldf,
  propmap,
  sigels,
  prologMaker = function(id, ...) sprintf("id: \%s", id)
)
}
\arguments{
\item{ldf}{a 'long format' data.frame as created by cyclicSigset}

\item{propmap}{a character vector with names of elements corresponding to 'abbreviated' relationship
tokens and element values corresponding to full relationship-naming strings}

\item{sigels}{a named character vector associating cell types (names) to genes expressed in a cyclic set,
one element per type}

\item{prologMaker}{a function with arguments (id, ...), in which id is character(1),
that generates a vector of strings that will be used for each cell type-specific term.}
}
\value{
a character vector, strings can be concatenated to OBO
}
\description{
use output of cyclicSigset to generate a series of character vectors constituting OBO terms
}
\note{
ldfToTerms is not sufficiently general to produce terms for any reasonably
populated long data frame/propmap combination, but it is a working example for the
cyclic set context.
}
\examples{
# a set of cell types -- names are cell type token, values are genes expressed in a
# cyclic set -- each cell type expresses exactly one gene in the set and fails to
# express all the other genes in the set.  See Figs 3 and 4 of Bakken et al [PMID 29322913].
sigels = c("CL:X01"="GRIK3", "CL:X02"="NTNG1", "CL:X03"="BAGE2", 
        "CL:X04"="MC4R", "CL:X05"="PAX6", "CL:X06"="TSPAN12", "CL:X07"="hSHISA8", 
        "CL:X08"="SNCG", "CL:X09"="ARHGEF28", "CL:X10"="EGF")
# create the associated long data frame
ldf = cyclicSigset(sigels)
# describe the abbreviations
pmap = c("hasExp"="has_expression_of", lacksExp="lacks_expression_of")

# now define the prolog for each cell type
makeIntnProlog = function(id, ...) {
# make type-specific prologs as key-value pairs
    c(
      sprintf("id: \%s", id),
      sprintf("name: \%s-expressing cortical layer 1 interneuron, human", ...),
      sprintf("def: '\%s-expressing cortical layer 1 interneuron, human described via RNA-seq observations' [PMID 29322913]", ...),
      "is_a: CL:0000099 ! interneuron",
      "intersection_of: CL:0000099 ! interneuron")
}
tms = ldfToTerms(ldf, pmap, sigels, makeIntnProlog)
cat(tms[[1]], sep="\n")
}
