% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotRank.R
\name{screeplot_rank}
\alias{screeplot_rank}
\alias{plotRank}
\alias{screeplot_rank,ANY-method}
\title{Functions to create a scree plot for model selection.}
\usage{
screeplot_rank(x, ...)

\S4method{screeplot_rank}{ANY}(
  x,
  maxcomp = length(x$lambdas),
  type = c("point", "barplot", "lines"),
  ...
)

plotRank(x, ..., name = "rank_GMF")
}
\arguments{
\item{x}{Output of \code{\link[sgdGMF]{sgdgmf.rank}},
\code{\link{calculateRankGMF}} or
\code{\link{runRankGMF}}.}

\item{...}{For the \code{screeplot_rank} generic, additional arguments to
pass to specific methods.}

\item{maxcomp}{Numeric scalar indicating the number of eigenvalues to plot.}

\item{type}{Type of scree plot to make: choose between 'point', 'barplot'
or 'lines.}

\item{name}{String specifying the name to be used to obtain the rank object
in the metadata.}
}
\value{
A \link{plot} object.
}
\description{
Functions to create a scree plot for model selection.
}
\details{
This function plots a screeplot based on the output of
\code{\link{runRankGMF}} or \code{\link[sgdGMF]{sgdgmf.rank}}.
}
\examples{
example_sce <- mockSCE(ncells = 200, ngenes = 100)
example_sce <- runRankGMF(example_sce,
                         exprs_values="counts",
                         family = poisson(),
                         maxcomp = 10)
head(metadata(example_sce)[["rank_GMF"]])
plotRank(example_sce)
}
\seealso{
\code{\link{runRankGMF}}, to calculate the eigenvalues.
}
\author{
Alexandre Segers
}
