% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSegment.R
\name{plotSegment}
\alias{plotSegment}
\title{Plot genome segmentation}
\usage{
plotSegment(
  seg,
  exclude = NULL,
  type = c("ranges", "barplot", "boxplot"),
  region = NULL
)
}
\arguments{
\item{seg}{the segmentation GRanges returned by \code{segmentDensity} function}

\item{exclude}{GRanges of excluded region}

\item{type}{the type of plot returned. Choices are segmentation plot
included ranges information, barplot showing segmentation states' distribution across chromosome,
or a box plot indicating average density within each states.
Default is all plots are displayed.
The y axis \code{"density"} represent square root of overlap counts within segment length. If a user defined
segmentation GRanges is given, the y axis is default to be 1 for all states in segmentation plot.}

\item{region}{GRanges of stricted region that want to be plotted.}
}
\value{
A \code{ggplot} set by \code{type} argument
}
\description{
Plot genome segmentation
}
\examples{

example("segmentDensity")
plotSegment(seg, exclude, type = "ranges")
plotSegment(seg, exclude, type = "barplot")
plotSegment(seg, exclude, type = "boxplot")
}
