% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.rpm.R
\name{coverage.rpm}
\alias{coverage.rpm}
\alias{coverage.rpm,GRanges-method}
\alias{coverage.rpm,CompressedGRangesList-method}
\alias{coverage.rpm,IRanges-method}
\title{Coverage calculation and normalization to reads per million (rpm)}
\usage{
coverage.rpm(data, scale = 1e+06, ...)

\S4method{coverage.rpm}{GRanges}(data, scale = 1e+06, ...)

\S4method{coverage.rpm}{CompressedGRangesList}(data, scale = 1e+06, ...)

\S4method{coverage.rpm}{IRanges}(data, scale = 1e+06, ...)
}
\arguments{
\item{data}{\link[GenomicRanges:GenomicRanges]{GenomicRanges::GenomicRanges} or \link[IRanges:IRanges]{IRanges::IRanges} with the
reads information}

\item{scale}{By default, a million (1e6), but you could change this value
for abnormal high or low amount of reads.}

\item{\dots}{Additional arguments to be passed to \code{coverage} function}
}
\value{
\code{RleList} object with the coverage objects
}
\description{
Calculates the coverage values from a \link[GenomicRanges:GRanges]{GenomicRanges::GRanges} or
\link[IRanges:IRanges]{IRanges::IRanges} object normalized to reads per million, allowing the
comparison of experiments with a different absolut number of reads.
}
\examples{
# Load the example dataset and get the coverage
data(nucleosome_htseq)
cov <- coverage.rpm(nucleosome_htseq)
print(cov)
# Plot it
library(ggplot2)
cover <- as.vector(cov[["chr1"]])
qplot(seq_along(cover), cover, geom="line", ylab="coverage",
  xlab="position")

}
\seealso{
\code{\link[=processReads]{processReads()}}, \code{\link[IRanges:coverage]{IRanges::coverage()}}
}
\author{
Oscar Flores \email{oflores@mmb.pcb.ub.es}
}
\keyword{manip}
