% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_correction.R
\name{ruvs_qc}
\alias{ruvs_qc}
\title{Remove Unwanted Variation (RUV) between batches}
\usage{
ruvs_qc(object, replicates, k = 3, assay.type = NULL, name = NULL, ...)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{replicates}{list of numeric vectors, indexes of replicates}

\item{k}{The number of factors of unwanted variation to be estimated from 
the data.}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{name}{character, name of the resultant assay in case of multiple assays}

\item{...}{other parameters passed to \code{link[RUVSeq]{RUVs}}}
}
\value{
A SummarizedExperiment object with the normalized data.
}
\description{
An interface for \code{link[RUVSeq]{RUVs}} method
}
\examples{
data(toy_notame_set)
# Batch correction
replicates <- list(which(toy_notame_set$QC == "QC"))
batch_corrected <- ruvs_qc(toy_notame_set, replicates = replicates)
# Evaluate batch correction
pca_bhattacharyya_dist(toy_notame_set, batch = "Batch")
pca_bhattacharyya_dist(batch_corrected, batch = "Batch")

}
