% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_clustering.R
\name{compress_clusters}
\alias{compress_clusters}
\title{Compress clusters of features to a single feature}
\usage{
compress_clusters(object)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}
}
\value{
A SummarizedExperiment object with only one feature per 
cluster.
}
\description{
This function compresses clusters found by cluster_features, keeping only 
the feature with the highest median peak area. The features that were 
discarded are recorded in feature data, under Cluster_features.
}
\examples{
data(toy_notame_set)
clustered <- cluster_features(toy_notame_set, 
  rt_window = 1, corr_thresh = 0.5, d_thresh = 0.6)
compressed <- compress_clusters(clustered)

}
\seealso{
\code{\link{cluster_features}}
}
