% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{plot_tsne_hexbin}
\alias{plot_tsne_hexbin}
\title{t-SNE hexbin plot}
\usage{
plot_tsne_hexbin(
  object,
  all_features = FALSE,
  center = TRUE,
  scale = "uv",
  pca_method = "nipals",
  perplexity = 30,
  fill = "Injection_order",
  summary_fun = "mean",
  bins = 10,
  title = "t-SNE",
  subtitle = paste("Perplexity:", perplexity),
  fill_scale = getOption("notame.fill_scale_con"),
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a SummarizedExperiment object}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{center}{logical, should the data be centered prior to PCA? (usually 
yes)}

\item{scale}{scaling used, as in  \code{\link[pcaMethods]{prep}}. Default is 
"uv" for unit variance}

\item{pca_method}{the method used in PCA if there are missing values}

\item{perplexity}{the perplexity used in t-SNE}

\item{fill}{character, name of the column used for coloring the hexagons}

\item{summary_fun}{the function used to compute the value for each hexagon}

\item{bins}{the number of bins in x and y axes}

\item{title, subtitle}{the titles of the plot}

\item{fill_scale}{the fill scale as returned by a ggplot function}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional arguments passed to \code{\link[Rtsne]{Rtsne}}}
}
\value{
A ggplot object.
}
\description{
Computes t-SNE into two dimensions and plots the map as hexagonal bins, 
where the value of the coloring variable is summarised for each bin, by 
default as the mean of the values inside the bin.
In case there are missing values, PCA is performed using the nipals method 
of \code{\link[pcaMethods]{pca}}, the method can be changed to "ppca" if 
nipals fails.
}
\examples{
data(toy_notame_set, package = "notame")
plot_tsne_hexbin(toy_notame_set, perplexity = 10)

}
\seealso{
\code{\link[Rtsne]{Rtsne}}
}
