% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{plot_pca_hexbin}
\alias{plot_pca_hexbin}
\title{PCA hexbin plot}
\usage{
plot_pca_hexbin(
  object,
  pcs = c(1, 2),
  all_features = FALSE,
  center = TRUE,
  scale = "uv",
  fill = "Injection_order",
  summary_fun = "mean",
  bins = 10,
  title = "PCA",
  subtitle = NULL,
  fill_scale = getOption("notame.fill_scale_con"),
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a SummarizedExperiment object}

\item{pcs}{numeric vector of length 2, the principal components to plot}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{center}{logical, should the data be centered prior to PCA? (usually 
yes)}

\item{scale}{scaling used, as in \code{\link[pcaMethods]{prep}}. Default is 
"uv" for unit variance}

\item{fill}{character, name of the column used for coloring the hexagons}

\item{summary_fun}{the function used to compute the value for each hexagon}

\item{bins}{the number of bins in x and y axes}

\item{title, subtitle}{the titles of the plot}

\item{fill_scale}{the fill scale as returned by a ggplot function}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional arguments passed to \code{\link[pcaMethods]{pca}}}
}
\value{
A ggplot object.
}
\description{
Computes PCA using one of the methods provided in the Bioconductor package
pcaMethods and plots the two first principal components as hexagonal bins, 
where the value of the coloring variable is summarised for each bin, by 
default as the mean of the values inside the bin.
}
\examples{
data(toy_notame_set, package = "notame")
plot_pca_hexbin(toy_notame_set)

}
\seealso{
\code{\link[pcaMethods]{pca}}
}
