% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_t_test}
\alias{perform_t_test}
\title{Pairwise and paired t-tests}
\usage{
perform_t_test(
  object,
  formula_char,
  is_paired = FALSE,
  id = NULL,
  all_features = FALSE,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{formula_char}{character, the formula to be used in the linear model 
(see Details)}

\item{is_paired}{logical, use paired t-test}

\item{id}{character, name of the subject identification column for paired 
version}

\item{all_features}{should all features be included in FDR correction?}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other parameters passed to \code{\link{t.test}}}
}
\value{
A data frame with the results.
}
\description{
Performs pairwise and paired t-tests. The R default is Welch's t-test 
(unequal variances), use var.equal = TRUE for Student's t-test. Use 
\code{is_paired} for paired t-tests.
}
\details{
P-values of each comparison are corrected separately from each 
other.
}
\examples{
data(toy_notame_set, package = "notame")
# Including QCs as a study group for example
t_test_results <- perform_t_test(toy_notame_set, 
  formula_char = "Feature ~ Group")
# Using paired mode (pairs with QC are skipped as there are no common IDs in 
# 'toy_notame_set')
t_test_results <- perform_t_test(toy_notame_set,
  formula_char = "Feature ~ Time", is_paired = TRUE, id = "Subject_ID")
# Only two groups
t_test_results <- perform_t_test(notame::drop_qcs(toy_notame_set),
  formula_char = "Feature ~ Group")

}
\seealso{
\code{\link[stats]{t.test}}
}
