% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastqcDataList.R
\docType{class}
\name{FastqcDataList-class}
\alias{FastqcDataList-class}
\alias{FastqcDataList}
\title{The FastqcDataList Object Class}
\usage{
FastqcDataList(x)
}
\arguments{
\item{x}{Character vector of file paths specifying paths to FastQC reports}
}
\value{
An object of class FastqcDataList
}
\description{
The FastqcDataList Object Class
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\section{Slots}{

\describe{
\item{\code{...}}{this can either be a single character vector of paths to FASTQC
files, or several instances of .FastqcFile objects}
}}

\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)
fdl

}
